Include "Winhelp.jsh"
 include "winhlp32.jsm"
;Copyright 1997, 1999 by Henter-Joyce, Inc.
#Macro file for Windows Help, 1/95
;Modified and updated 3/30/99 by D.B.

 include "hjconst.jsh"
 include "hjglobal.jsh"

Function AutoStartEvent()
if (ToggleRestriction()) then
ToggleRestriction () ; turn restriction off
endif
EndFunction

Function SayNonHighlightedText(int hwnd,string buffer)
; text event macro for speaking all newly written non-highlighted
# text.
# Currently it only speaks text being written to the help window.
# it is passed two parameters, the handle of the window where the text
# has been written, and a buffer containing the text.
var
string TheClass,
string TheRealName

let TheClass = GetWindowClass(hwnd)
let TheRealName = GetWindowName (GetRealWindow (GetFocus()))

;wn1="MS_WINTOPIC"
if ((TheClass==wn1) ||
;wn2="MS_WINNOTE"
(TheClass == wn2) ||
;wn3="MS_WINNSR"
(TheClass == wn3) ||
;wn4="MS_WINSR"
(TheClass == wn4)  ||
;wn5="#32771"
TheClass == wn5 ) then
Say(buffer, ot_buffer)
let GlobalWinHlp32Handle	= hwnd	
return
endif
;wn6="Static"
If (TheClass == wn6) then
;wn7="Find Setup Wizard"
	If (TheRealName == wn7) then
		Say(buffer, ot_buffer)
		return
	EndIf
EndIf ;Class is static
EndFunction

Function SayFocusedWindow()

;wc13="SysTabControl32"
If ((GetWindowClass (GlobalPrevFocus) == wc13) &&
;wc9="SysTreeView32"
(GetWindowClass (GlobalFocusWindow) == wc9)) then
	SaveCursor ()
	InvisibleCursor()
	MoveToWindow (GetPriorWindow(GlobalFocusWindow))
	SayChunk()
EndIf
If (GetControlID (GlobalFocusWindow) == 1001) then
	Say(msg14, ot_message) ;"Type the word or phrase you want to find"
	Say(msg15, ot_control_name) ;"edit"
	return
EndIf
If (GetControlID (GlobalFocusWindow) == 6001) then
	Say(msg16, ot_message) ;"Select some matching words to narrow your search"
	Say(msg17, ot_message) ;"text viewer"
	return
EndIf
If (GetControlID (GlobalFocusWindow) == 6007) then
	Say(msg18, ot_message) ;"Select a topic, and then select the display button"
	Say(msg17, ot_message) ;"text viewer"
	return
EndIf
SayWindowTypeandText (GlobalFocusWindow)
EndFunction

Script ScriptFileName(); {Insert+Q}
ScriptAndAppNames ("Windows Help")
EndScript

Script ScreenSensitiveHelp()
var
	String TheClass
Let TheClass = GetWindowClass (GetCurrentWindow ())
;wn22="ms_winnote"
if (TheClass == wn22) then
	Say(msg23, ot_help) ;"This is a Windows help note"
	Say(msg24, ot_help) ;"It contains help that is relevant to the current control"
	Say(msg25, ot_help) ;"to reed this note with the jaws cursor use control plus insert down arrow"
	Say(msg66, ot_help) ;"or control plus page down or page up to read the next or prior screen"
	Say(msg26, ot_help) ;"press escape or enter to return to the current application"
	return
endif
;wn27="ms_wintopic"
if (TheClass == wn27) then
	Say(msg28, ot_help) ;"This is a Windows help topic"
	Say(msg29, ot_help) ;"It contains help specific to a requested topic"
	Say(msg30, ot_help) ;"to read this topic with the jaws cursor use control plus insert down arrow"
	Say(msg66, ot_help) ;"or control plus page down or page up to read the next or prior screen"
	Say(msg31, ot_help) ;"press alt plus f4 to return to the current application"
	return
endif
;wn32="ms_winnsr"
if (TheClass == wn32) then
	Say(msg33, ot_help) ;"This is the jaws for windows  help title"
	Say(msg34, ot_help) ;"it generally contains a title for the current topic"
	return
endif
;wn35="ms_winhelp"
if (TheClass == wn35) then
	Say(msg67, ot_help) ;"This is a help window"
	Say(msg30, ot_help) ;"to read this topic with the jaws cursor use control plus insert down arrow"
	Say(msg66, ot_help) ;"or control plus page down or page up to read the next or prior screen"
	return
endif
PerformScript ScreenSensitiveHelp ()
EndScript

Script HotKeyHelp()
var
	string WindowName,
	int TheTypeCode,
	string TheClass
let WindowName= GetWindowName (GetRealWindow (GetFocus ()))
let TheTypeCode = GetWindowTypeCode (GetCurrentWindow())
Let TheClass = GetWindowClass (GetCurrentWindow ())

if  (TheTypeCode == wt_unknown) then
;wn22="ms_winnote"
	if (TheClass == wn22) then
		Say(msg25 + GetScriptKeyName ("SayHelpWindow"), ot_help) ;"to reed this note with the jaws cursor use control plus insert down arrow"
		return
	endif
;wn27="ms_wintopic"
	if (TheClass == wn27 || TheClass == "ms_WinHelp") then
		Say(msg30 + GetScriptKeyName ("SayHelpWindow"), ot_help) ;"to read this topic with the jaws cursor use control plus insert down arrow"
		Say(msg68, ot_help) ; "to move from link to link use tab and shift tab"
		Say(msg69, ot_help) ; "for the table of contents use c"
		Say(msg70, ot_help) ; "to perform a search use s"
		Say(msg71, ot_help) ; "to move to the prior help screen use b"
		Say(msg72, ot_help) ; "for a list of prior accessed help screens use t"
		Say(msg73, ot_help) ; "to move to the prior topic in the browse list use <"
		Say(msg74, ot_help) ; "to move to the next topic in the browse list use >"
		return
	endif
EndIf
If (GetWindowTypeCode (GetRealWindow (GetFocus ())) == wt_dialog) then
;wn39="Search"
	If (WindowName == wn39) then
		Say(msg40, ot_help) ;"Use the Tab key or the following Windows hot keys"
		Say(msg41, ot_help) ;"Type a word edit box with list use alt w"
		Say(msg42, ot_help) ;"Show topics button use alt s"
		Say(msg43, ot_help) ;"Go to button use alt g"
		Say(msg44, ot_help) ;"Press enter to accept the changes or press escape to cancel"
		Return
	EndIf
	HotKeyHelpDefaultLoop()
Else
		Say(msg45, ot_help) ;"Not a dialog box"
endif
EndScript

Function SayHighlightedText(int hwnd,string buffer)
; HighlightedText event macro for speaking all newly written highlighted
; text.
if((GetScreenEcho() > 0) && (GetControlID (hwnd) != 6001) && (GetControlID (hwnd) != 6007)) Then
	Say(buffer, ot_buffer)
	Return
EndIf
if ((GetControlID (GetCurrentWindow ()) == 6001) && (GetControlID (hwnd) == 6001)) then
	Say(buffer, ot_buffer)
	return
endif
if ((GetControlID (GetCurrentWindow ()) == 6007) && (GetControlID (hwnd) == 6007)) then
	Say(buffer, ot_buffer)
endif
EndFunction

Script SayHelpWindow ()
	JAWSCursor()
	if (GlobalWinHlp32Handle	> 0) then	
		MoveToWindow (GlobalWinHlp32Handle)
		SayAll()
	endif		
EndScript

Script SayPriorScreen ()

;display and read prior screen, even when J cursor on
{PageUp} ; tell help to do page up
	JAWSCursor()
	if (GlobalWinHlp32Handle	> 0) then	
		MoveToWindow (GlobalWinHlp32Handle)
		SayAll()
	endif		
EndScript

Script SayNextScreen ()

;display and read next screen, even when J cursor on
{PageDown} ; tell help to do page down
	JAWSCursor()
	if (GlobalWinHlp32Handle	> 0) then	
		MoveToWindow (GlobalWinHlp32Handle)
		SayAll()
	endif		
EndScript

Script WindowKeysHelp()

;wn47="jaws help system"
	if (GetWindowName (GetRealWindow (GetCurrentWindow())) == wn47) then
		Say(msg48, ot_help) ;"The Following help system keyboard commands can be useful"
		Say(msg49, ot_help) ;"changes button use g"
		Say(msg50, ot_help) ;"Contents button use c"
		Say(msg51, ot_help) ;"Search button use s"
		Say(msg52, ot_help) ;"jaws basics button use j"
		Say(msg53, ot_help) ;"back button use b"
		Say(msg54, ot_help) ;"previous button use less than"
		Say(msg55, ot_help)	 ;"next button use greater than"
		Say(msg56, ot_help) ;"print button use p"
		Say(msg57, ot_help) ;"help tips button use h"
		Say(msg58, ot_help) ;"Quick reference button use q"
		Say	 (msg59, ot_help) ;"technical reference button use r"
		Say(msg60, ot_help) ;"windows reference button use w"
		Say(msg61, ot_help) ;"macro help button use o"
		Say(msg62, ot_help) ;"Setup guide button use space bar"
		return
	endif
	WindowKeysHelpDefault()
EndScript

Script TurnOnPCCursorOnEscape ()
 ;make sure that the pc cursor is turned on before leaving help
PCCursor()
Say(msg63, ot_message) ;"escape"
{escape}	
EndScript

Script TurnOnPCCursorOnF4 ()
 ;make sure that the pc cursor is turned on before leaving help
PCCursor()
Say(msg65, ot_message) ;"alt plus f4"
{alt+f4}	
EndScript

Script NextControl ()
{tab}
pause()
if ((GetCharacterAttributes () & ATTRIB_GRAPHIC) == ATTRIB_GRAPHIC ) then
	SayChunk()
endif
EndScript

Script PriorControl ()
{shift+tab}
pause()
if ((GetCharacterAttributes () & ATTRIB_GRAPHIC) == ATTRIB_GRAPHIC ) then
	SayChunk()
endif
EndScript

